unit Unit1;

//      
//     .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Math;

type
  TForm1 = class(TForm)
    CbBoxType: TComboBox;
    EdValue: TEdit;
    Memo1: TMemo;
    StTextDesc: TStaticText;
    EditRange: TEdit;
    Label1: TLabel;
    StTextSize: TStaticText;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    StTextTest: TStaticText;
    Label2: TLabel;
    procedure CbBoxTypeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EdValueChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

type
TptDescType = ^TDescType;
  TDescType = packed record
     Name  : string[32];      //  
     Group : byte;            //  
     Rang  : string[64];      //  
     Desc  : string[32];      // 
     Size  : byte;            //   
     Min   : Extended;        //  
     Max   : Extended;        //  
     case Num : byte of
       // Group 1
       0: (Dat0 : Integer);
       1: (Dat1 : Cardinal);
       // Group 2
       2: (Dat2 : Shortint);
       3: (Dat3 : Smallint);
       4: (Dat4 : Longint);
       5: (Dat5 : Int64);
       6: (Dat6 : Byte);
       7: (Dat7 : Word);
       8: (Dat8 : Longword);
       // Group 3
       9:  (Dat9  : Real);
       10: (Dat10 : Real48);
       11: (Dat11 : Single);
       12: (Dat12 : Double);
       13: (Dat13 : Extended);
       14: (Dat14 : Comp);
       15: (Dat15 : Currency);
end;

const ArrTypes : array[0..15] of TDescType =
(
  //-------------------------------------------------------------
  // (Group = 1) Generic integer types for 32-bit implementations of Delphi
  (Name : 'Integer';  Group : 1;
   Rang : '-2147483648 .. 2147483647';
   Desc : '32-bit  ';   Size : SizeOF(Integer);
   Min  :  -2147483648E0;    Max : 2147483647;
   Num  : 0; Dat0 : 2147483647),

  (Name : 'Cardinal';  Group : 1;
   Rang : '0..4294967295';
   Desc : '32-bit  ';  Size : SizeOF(Cardinal);
   Min  : 0;              Max : 4294967295;
   Num  : 1; Dat1 : 4294967295),
  //-------------------------------------------------------------
  // (Group = 2) Fundamental integer types
  (Name : 'Shortint';  Group : 2;
   Rang : '-128 .. 127';
   Desc : '8-bit   ';    Size : SizeOF(Shortint);
   Min  : -128;           Max : 127;
   Num  : 2; Dat2 : 127),

  (Name : 'Smallint';  Group : 2;
   Rang : '-32768 .. 32767';
   Desc : '16-bit  ';   Size : SizeOF(Smallint);
   Min  : -32768;         Max : 32767;
   Num  : 3; Dat3 : 32767),

  (Name : 'Longint';   Group : 2;
   Rang : '-2147483648 .. 2147483647';
   Desc : '32-bit  ';   Size : SizeOF(Longint);
   Min  :  -2147483648E0;   Max : 2147483647;
   Num  : 4; Dat4 : 2147483647),

  (Name : 'Int64';     Group : 2;
   Rang : '-2^63 .. 2^63 - 1';
   Desc : '64-bit  ';   Size : SizeOF(Int64);
   Min  : -9223372036854775808E0;    Max : 9223372036854775807;
   Num  : 5; Dat5 : 9223372036854775807),

  (Name : 'Byte';      Group : 2;
   Rang : '0 .. 255';
   Desc : '8-bit  ';  Size : SizeOF(Byte);
   Min  : 0;    Max : 255;
   Num  : 6; Dat6 : 255),

  (Name : 'Word';      Group : 2;
   Rang : '0 .. 65535';
   Desc : '16-bit  '; Size : SizeOF(Word);
   Min  : 0;    Max : 65535;
   Num  : 7; Dat7 : 65535),

  (Name : 'Longword';   Group : 2;
   Rang : '0 .. 4294967295';
   Desc : '32-bit  '; Size : SizeOF(Longword);
   Min  : 0;    Max : 4294967295;
   Num  : 8; Dat8 : 4294967295),
   //-------------------------------------------------------------
   //-------------------------------------------------------------
   // (Group = 3) Generic real types
   //  
  (Name : 'Real';     Group : 3;
   Rang : '5,0E-324 .. sign 1,7E308';
   Desc : '15-16 - '; Size : SizeOF(Real);
   Min  : -1.7E308;    Max : 1.7E308;
   Num  : 9; Dat9 : 1.7E308),
   //-------------------------------------------------------------
   // (Group = 4) Fundamental real types
   // ,     11 (   )
  (Name : 'Real48';   Group : 4;
   Rang : '2,9E-39 .. sign 1,7E38';
   Desc : '11-12 - '; Size : SizeOF(Real48);
   Min  : -1.7E38;    Max : 1.7E38;
   Num  : 10; Dat10 : 1E38),

   // ,     7 (   )
  (Name : 'Single';   Group : 4;
   Rang : '1,5E-45 .. sign 3,4E38';
   Desc : '7-8 - '; Size : SizeOF(Single);
   Min  : -3.4E38;    Max : 3.4E38;
   Num  : 11; Dat11 : 3.4E38),

   //  
   (Name : 'Double';   Group : 4;
   Rang : '5,0E-324 .. sign 1,7E308';
   Desc : '15-16 - '; Size : SizeOF(Double);
   Min  : -1.7E308;    Max : 1.7E308;
   Num  : 12; Dat12 : 1.7E308),

   //  
  (Name : 'Extended';   Group : 4;
   Rang : '3,6E-4951 .. sign 1,1E4932';
   Desc : '19-20 - '; Size : SizeOF(Extended);
   Min  : -1.1E4932;    Max : 1.1E4932;
   Num  : 13; Dat13 : 1.1E4932),

   //  
  (Name : 'Comp';   Group : 4;
   Rang : '-9223372036854775808 .. 9223372036854775807';
   //      -2^63                .. 2^63 - 1
   Desc : '19-20 - '; Size : SizeOF(Comp);
   Min  : -9223372036854775809E0;  Max : 9223372036854775807E0;
   Num  : 14; Dat14 : 0),
   // (     )

   //  
  (Name : 'Currency';   Group : 4;
   Rang : '-922337203685477,5808 .. 922337203685477,5807';
   Desc : '19-20 - '; Size : SizeOF(Currency);
   Min  : -9223372036854775809E-4;  Max : 9223372036854775807E-4;
   Num  : 15; Dat15 : 922337203685477)
   // (     )
   //-------------------------------------------------------------
);

//  
var DescType : TDescType;

//     
function ByteToHexStr (RqByte : byte): string;
const HexCharsArray : array[0..15] of char =
   ('0','1','2','3','4','5','6','7',
    '8','9','A','B','C','D','E','F');
begin
 //      Hex - 
 Result:= HexCharsArray[$0F and RqByte];
 //       
 Result:= HexCharsArray[($F0 and RqByte) shr 4] + Result;
end;

//       
//   RqSize ,    
// RqAddr.
function MemToHexStr (RqAddr : pointer; RqSize : integer): string;
var pt1 : ^byte;    //   
    Ind : integer;  //    
begin
  Result := '';
  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1 := RqAddr;
    try
      for Ind := 0 to RqSize -1 do
      begin
        Result := Result + ByteToHexStr(pt1^);
        //   
        pt1 := Ptr(Integer(pt1) + 1);
      end;
    except
       ShowMessage(' .  .');
    end;
  end;
end;

//     RqSize ,  
//   RqAddr,     .
procedure MemToHexAndCharDump (RqAddr   : pointer;
                               RqSize   : integer;
                               RqReport : TMemo);
const SLen    = 1;                //      
var   pt1     : ^byte;            //      
      BCount  : integer;          //     
      SCount  : integer;          //      
      WCount  : integer;          //      
      HStr    : string[80];       //   
      CStr    : string[80];       //   
begin

  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1     := RqAddr;
    BCount  := RqSize;
    RqReport.Lines.Add('Addr' + #09#09 + 'Hex' + #09 + 'Char');
    try
      repeat //    
          HStr   := Format('%p',[pt1]) + ':' + #09;
          CStr   := '';
          SCount := SLen;
          WCount := SizeOf(integer);
          repeat  //    
            HStr := HStr + ByteToHexStr(pt1^);
            WCount := WCount - 1;
            if WCount <= 0
            then begin
               HStr := HStr + ' ';
               WCount := SizeOf(integer);
            end;
            if pt1^ < $20  //   
            then CStr := CStr + '.'
            else CStr := CStr + Char(pt1^);
            //   
            pt1 := Ptr(Integer(pt1) + 1);
            BCount := BCount - 1;
            SCount := SCount - 1;
          until (SCount <=0);
          RqReport.Lines.Add(HStr + ' ' + #09 + CStr);
      until (BCount <= 0);
    except
       ShowMessage(' .  .');
    end;
  end;
end;


procedure TForm1.CbBoxTypeClick(Sender: TObject);
var Ind   : integer;
    RqDat : pointer;
begin
   Ind := CbBoxType.ItemIndex;
   if (Ind < 0) or (Ind > High(ArrTypes)) then Exit;

   //      
   Move(ArrTypes[Ind], DescType, SizeOf(DescType));

   //  
   StTextDesc.Caption  := ArrTypes[Ind].Desc;
   EditRange.Text := ArrTypes[Ind].Rang;
   StTextSize.Caption := IntToStr(DescType.Size);

   //  
   Memo1.Clear;
   RqDat := Addr(DescType.Dat0);
   MemToHexAndCharDump(RqDat, DescType.Size, Memo1);

   //     
   case DescType.Group of
   1..2 : EdValue.Text := IntToStr(Int64(RqDat^));
   3..4 : case DescType.Num of
          9  : EdValue.Text := FloatToStr(Real(RqDat^));
          10 : EdValue.Text := FloatToStr(Real48(RqDat^));
          11 : EdValue.Text := FloatToStr(Single(RqDat^));
          12 : EdValue.Text := FloatToStr(Double(RqDat^));
          13 : EdValue.Text := FloatToStr(Extended(RqDat^));
          14 : EdValue.Text := FloatToStr(Comp(RqDat^));
          15 : EdValue.Text := FloatToStr(Currency(RqDat^));
          end;
   end;
end;

//        
function ProStrToFloat (RqStr   : string;
                    var RqFloat : Extended) : boolean;
begin
  Result  := False;     //   
  try
    if RqStr <> ''
    then  RqFloat := StrToFloat(RqStr)
    else  RqFloat := 0;
    Result  := True;    //   
  except
    ShowMessage('    ');
  end;
end;


//   
procedure TForm1.EdValueChange(Sender: TObject);
var RqDat  : pointer;
    RqSize : byte;
    Test   : Extended;
begin
    RqDat := Addr(DescType.Dat0);

    if ProStrToFloat(EdValue.Text, Test)
    then begin
       Memo1.Clear;
       if (Test <= DescType.Max) and
          (Test >= DescType.Min)
       then begin
            case DescType.Group of
            1..2 : begin
                      Int64(RqDat^) := Trunc(Test);
                      StTextTest.Caption := IntToStr(Int64(RqDat^));
                   end;
            3..4 : case DescType.Num of
                   9  : begin
                            Real(RqDat^) := Test;
                            StTextTest.Caption := FloatToStr(DescType.Dat9);
                        end;
                   10 : begin
                           Real48(RqDat^) := Test;
                           StTextTest.Caption := FloatToStr(DescType.Dat10);
                        end;
                   11 : begin
                           Single(RqDat^) := Test;
                           StTextTest.Caption := FloatToStr(DescType.Dat11);
                        end;
                   12 : begin
                           Double(RqDat^) := Test;
                           StTextTest.Caption := FloatToStr(DescType.Dat12);
                        end;
                   13 : begin
                           Extended(RqDat^) := Test;
                           StTextTest.Caption := FloatToStr(DescType.Dat13);
                        end;
                   14 : begin
                           Comp(RqDat^) := Test;
                           StTextTest.Caption := FloatToStr(DescType.Dat14);
                        end;
                   15 : begin
                           Currency(RqDat^) := Test;
                           StTextTest.Caption := FloatToStr(DescType.Dat15);
                        end;
                   end;
            end; // of case
            //  
            RqSize := DescType.Size;
            MemToHexAndCharDump(RqDat, RqSize, Memo1);
       end
       else ShowMessage ('  ');
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var Ind : integer;
begin
  CbBoxType.Clear;
  for Ind := 0 to High(ArrTypes)
  do CbBoxType.Items.Add(ArrTypes[Ind].Name);
  CbBoxType.ItemIndex := 0;
  CbBoxTypeClick(nil);
end;


end.
